<?php
// We start sessions
ob_start();
session_start();

$meta = "";
/******************************************************
------------------Required Configuration---------------
******************************************************/

$table_name = 'topsite';
if ( !class_exists('ORM') ){
	require 'lib/idiorm.php';
}
try{
	ORM::configure('sqlite:' . dirname(__FILE__) . '/database.sqlite');
	ORM::get_db()->exec("
		-- DROP TABLE IF EXISTS `$table_name`;
		CREATE TABLE IF NOT EXISTS `$table_name` (
            `id`          INTEGER NOT NULL PRIMARY KEY,
            `name`        VARCHAR(55) NOT NULL,
            `url`         VARCHAR(255) NOT NULL,
            `description` VARCHAR(255) NOT NULL,
            `banner`      VARCHAR(255) NOT NULL,
            `email`       VARCHAR(255) NOT NULL,
            `votes`       INTEGER NOT NULL,
            `status`      VARCHAR(2) NOT NULL,
            `categoryID`   INTEGER 
        );
	");
} catch(Exception $e){
	die('Exception: ' . $e->getMessage());
}

$configs = ORM::for_table('Configs')->find_many();


foreach($configs as $config) {
            

    //Password for administration
    $password = $config->password;   


// Webmaster Email
$mail_webmaster = $config->mail_webmaster;

// Site base URL
$base_url = $config->base_url;

/******************************************************
-----------------Optional Configuration----------------
******************************************************/
// Number of sites per page
$nb_site_page = $config->nb_site_page;

// Send an email when accepting/rejecting a web site
$mail = $config->mail;

// Site
$site_name = $config->site_name;
$site_slogan = $config->site_slogan;
$site_description = $config->site_description;

$site_index = $config->site_index;

// Design Name
$design = $config->design;

// CSS Theme
$theme = $config->theme;

// Captcha public key
$captcha_public = $config->captcha_public;

// Captcha secret key
$captcha_secret = $config->captcha_secret;
//Addthis secret key
$addthis_id = $config->addthis_id;

// Captcha public key
$head_code = htmlspecialchars_decode(str_replace('\"',"'",$config->head_code));
$default_sorting = $config->default_sorting;
// Captcha secret key
$footer_code = htmlspecialchars_decode(str_replace('\"',"'",$config->footer_code));
$hits_setting = $config->hits_setting;
$slider_setting = $config->slider_setting;
$vote_permission = $config->vote_permission;
}
